<?= $this->include('layout/header_admin') ?>

<div class="container mt-4">
    <div class="card shadow">
        <div class="card-header bg-warning">
            <h5 class="mb-0">✏️ Edit Aktivitas</h5>
        </div>

        <div class="card-body">
            <form action="/auth/aktivitas/update/<?= $aktivitas['id'] ?>"
                method="post"
                enctype="multipart/form-data">

                <!-- TANGGAL -->
                <div class="mb-3">
                    <label class="form-label">Tanggal</label>
                    <input type="date"
                        name="tanggal"
                        class="form-control"
                        value="<?= esc($aktivitas['tanggal']) ?>"
                        required>
                </div>

                <!-- JAM -->
                <div class="mb-3">
                    <label class="form-label">Jam</label>
                    <input type="time"
                        name="jam"
                        class="form-control"
                        value="<?= esc($aktivitas['jam']) ?>"
                        required>
                </div>

                <!-- NAMA AKTIVITAS -->
                <div class="mb-3">
                    <label class="form-label">Nama Aktivitas</label>
                    <input type="text"
                        name="nama_aktivitas"
                        class="form-control"
                        value="<?= esc($aktivitas['nama_aktivitas']) ?>"
                        required>
                </div>

                <!-- MEDIA TYPE -->
                <div class="mb-3">
                    <label class="form-label">Media</label>
                    <select name="media_type"
                        class="form-select"
                        onchange="toggleMediaEdit(this.value)">
                        <option value="">-- Tanpa Media --</option>
                        <option value="upload"
                            <?= $aktivitas['media_type'] === 'upload' ? 'selected' : '' ?>>
                            Upload Foto / Video
                        </option>
                        <option value="link"
                            <?= $aktivitas['media_type'] === 'link' ? 'selected' : '' ?>>
                            Link Video
                        </option>
                    </select>
                </div>

                <!-- MEDIA UPLOAD -->
                <div class="mb-3" id="mediaUploadEdit"
                    style="<?= $aktivitas['media_type'] === 'upload' ? '' : 'display:none' ?>">
                    <input type="file"
                        name="media_file"
                        class="form-control"
                        accept="image/*,video/*">
                </div>

                <!-- MEDIA LINK -->
                <div class="mb-3" id="mediaLinkEdit"
                    style="<?= $aktivitas['media_type'] === 'link' ? '' : 'display:none' ?>">
                    <input type="url"
                        name="media_link"
                        class="form-control"
                        placeholder="https://youtube.com/..."
                        value="<?= $aktivitas['media_type'] === 'link' ? esc($aktivitas['media']) : '' ?>">
                </div>

                <!-- PREVIEW MEDIA LAMA -->
                <?php if ($aktivitas['media']): ?>
                    <div class="mb-3">
                        <label class="form-label">Media Saat Ini</label><br>

                        <?php if ($aktivitas['media_type'] === 'upload'): ?>
                            <?php
                            $ext = pathinfo($aktivitas['media'], PATHINFO_EXTENSION);
                            ?>
                            <?php if (in_array($ext, ['jpg', 'jpeg', 'png'])): ?>
                                <img src="/uploads/aktivitas/<?= esc($aktivitas['media']) ?>"
                                    class="img-thumbnail"
                                    width="120">
                            <?php else: ?>
                                <video width="200" controls>
                                    <source src="/uploads/aktivitas/<?= esc($aktivitas['media']) ?>">
                                </video>
                            <?php endif ?>
                        <?php else: ?>
                            <a href="<?= esc($aktivitas['media']) ?>"
                                target="_blank"
                                class="btn btn-outline-primary btn-sm">
                                🔗 Lihat Video
                            </a>
                        <?php endif ?>
                    </div>
                <?php endif ?>

                <!-- BUTTON -->
                <div class="d-flex justify-content-between">
                    <a href="/auth/aktivitas"
                        class="btn btn-secondary">
                        ⬅ Kembali
                    </a>

                    <button class="btn btn-success">
                        💾 Update
                    </button>
                </div>

            </form>
        </div>
    </div>
</div>

<script>
    function toggleMediaEdit(type) {
        document.getElementById('mediaUploadEdit').style.display =
            type === 'upload' ? 'block' : 'none';

        document.getElementById('mediaLinkEdit').style.display =
            type === 'link' ? 'block' : 'none';
    }
</script>

<?= $this->include('layout/footer_admin') ?>